# Business Platform API Documentation

## Base URL
```
https://your-domain.com/api
```

## Authentication
All API requests require Bearer token authentication:
```
Authorization: Bearer {your-api-token}
```

### Get Token
```http
POST /auth/login
Content-Type: application/json

{
  "email": "user@example.com",
  "password": "password"
}
```

---

## CRM Endpoints

### Contacts
| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/contacts` | List all contacts |
| POST | `/contacts` | Create contact |
| GET | `/contacts/{id}` | Get contact |
| PUT | `/contacts/{id}` | Update contact |
| DELETE | `/contacts/{id}` | Delete contact |
| POST | `/contacts/import` | Import contacts CSV |
| GET | `/contacts/export` | Export contacts |

### Segments
| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/segments` | List segments |
| POST | `/segments` | Create segment |
| POST | `/segments/{id}/refresh` | Refresh dynamic segment |

### Pipelines & Opportunities
| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/pipelines` | List pipelines |
| GET | `/opportunities` | List opportunities |
| POST | `/opportunities/{id}/won` | Mark as won |
| POST | `/opportunities/{id}/lost` | Mark as lost |

---

## Accounting Endpoints

### Invoices
| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/invoices` | List invoices |
| POST | `/invoices` | Create invoice |
| POST | `/invoices/{id}/send` | Send invoice email |
| POST | `/invoices/{id}/payment` | Record payment |
| GET | `/invoices/{id}/pdf` | Download PDF |

### Bills
| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/bills` | List bills |
| POST | `/bills` | Create bill |
| POST | `/bills/{id}/payment` | Record payment |

### Expenses
| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/expenses` | List expenses |
| POST | `/expenses` | Create expense |
| POST | `/expenses/{id}/approve` | Approve expense |
| POST | `/expenses/{id}/reject` | Reject expense |

---

## HR Endpoints

### Employees
| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/employees` | List employees |
| POST | `/employees` | Create employee |
| POST | `/employees/{id}/terminate` | Terminate employee |

### Attendance
| Method | Endpoint | Description |
|--------|----------|-------------|
| POST | `/attendance/check-in` | Check in |
| POST | `/attendance/check-out` | Check out |
| GET | `/attendance/today` | Today's status |

### Leave
| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/leave-requests` | List requests |
| POST | `/leave-requests` | Submit request |
| POST | `/leave-requests/{id}/approve` | Approve |
| POST | `/leave-requests/{id}/reject` | Reject |

### Payroll
| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/payroll-runs` | List payroll runs |
| POST | `/payroll-runs/{id}/process` | Process payroll |
| POST | `/payroll-runs/{id}/approve` | Approve & pay |

---

## Task Management Endpoints

### Projects
| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/projects` | List projects |
| POST | `/projects` | Create project |
| GET | `/projects/{id}/tasks` | List project tasks |

### Tasks
| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/tasks` | List tasks |
| POST | `/tasks` | Create task |
| POST | `/tasks/{id}/complete` | Mark complete |
| PUT | `/tasks/{id}/status` | Update status |

### Time Tracking
| Method | Endpoint | Description |
|--------|----------|-------------|
| POST | `/time-entries/start` | Start timer |
| POST | `/time-entries/{id}/stop` | Stop timer |
| GET | `/time-entries/running` | Get running timer |

---

## Reports Endpoints

| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/reports/balance-sheet` | Balance Sheet |
| GET | `/reports/profit-loss` | Profit & Loss |
| GET | `/reports/cash-flow` | Cash Flow |
| GET | `/reports/aging-receivables` | AR Aging |
| GET | `/reports/aging-payables` | AP Aging |
| GET | `/reports/tax` | VAT Tax Report |
| GET | `/reports/sales` | Sales Report |

---

## Webhooks

Configure webhooks to receive real-time notifications:

### Events
- `contact.created`
- `invoice.paid`
- `invoice.overdue`
- `opportunity.won`
- `task.completed`
- `leave.approved`

### Payload Example
```json
{
  "event": "invoice.paid",
  "timestamp": "2026-01-30T08:00:00Z",
  "data": {
    "invoice_id": 123,
    "amount": "500.000",
    "currency": "BHD"
  }
}
```

---

## Rate Limits
- 1000 requests per minute per API key
- Bulk operations: 100 items per request

## Error Codes
| Code | Description |
|------|-------------|
| 400 | Bad Request |
| 401 | Unauthorized |
| 403 | Forbidden |
| 404 | Not Found |
| 422 | Validation Error |
| 429 | Rate Limited |
| 500 | Server Error |
