<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Invoice {{ $invoice->invoice_number }}</title>
    <style>
        body { font-family: 'Helvetica', sans-serif; font-size: 12px; color: #333; }
        .invoice { max-width: 800px; margin: 0 auto; padding: 30px; }
        h1 { color: #1B5E20; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        th { background: #f5f5f5; padding: 10px; text-align: left; }
        td { padding: 10px; border-bottom: 1px solid #eee; }
        .text-right { text-align: right; }
        .total { font-weight: bold; font-size: 14px; }
    </style>
</head>
<body>
    <div class="invoice">
        <h1>{{ $invoice->tenant->name }}</h1>
        <h2>INVOICE #{{ $invoice->invoice_number }}</h2>
        <p>Date: {{ $invoice->invoice_date->format('M d, Y') }}</p>
        <p>Due: {{ $invoice->due_date->format('M d, Y') }}</p>
        
        <h3>Bill To:</h3>
        <p>{{ $invoice->contact->company_name ?: $invoice->contact->full_name }}</p>
        <p>{{ $invoice->contact->email }}</p>
        
        <table>
            <thead>
                <tr>
                    <th>Description</th>
                    <th class="text-right">Qty</th>
                    <th class="text-right">Rate</th>
                    <th class="text-right">Amount</th>
                </tr>
            </thead>
            <tbody>
                @foreach($invoice->items as $item)
                <tr>
                    <td>{{ $item->description }}</td>
                    <td class="text-right">{{ $item->quantity }}</td>
                    <td class="text-right">{{ $invoice->currency }} {{ number_format($item->unit_price, 3) }}</td>
                    <td class="text-right">{{ $invoice->currency }} {{ number_format($item->total, 3) }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
        
        <p class="text-right">Subtotal: {{ $invoice->currency }} {{ number_format($invoice->subtotal, 3) }}</p>
        <p class="text-right">Tax: {{ $invoice->currency }} {{ number_format($invoice->tax_amount, 3) }}</p>
        <p class="text-right total">Total: {{ $invoice->currency }} {{ number_format($invoice->total, 3) }}</p>
    </div>
</body>
</html>
