<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Payslip</title>
    <style>
        body { font-family: 'Helvetica', sans-serif; font-size: 11px; }
        .payslip { max-width: 800px; margin: 0 auto; padding: 20px; }
        h1 { color: #1B5E20; }
        table { width: 100%; margin-bottom: 15px; }
        td { padding: 5px; }
        .section { margin-bottom: 20px; padding: 10px; background: #f5f5f5; }
        .net-pay { background: #1B5E20; color: white; padding: 15px; text-align: center; }
    </style>
</head>
<body>
    <div class="payslip">
        <h1>PAYSLIP</h1>
        <p>{{ $item->payrollRun->pay_period_start->format('M d') }} - {{ $item->payrollRun->pay_period_end->format('M d, Y') }}</p>
        
        <div class="section">
            <p><strong>{{ $item->employee->user->full_name }}</strong></p>
            <p>{{ $item->employee->employee_id }} | {{ $item->employee->job_title }}</p>
        </div>
        
        <table>
            <tr><td>Basic Salary</td><td>{{ $item->currency }} {{ number_format($item->basic_salary, 3) }}</td></tr>
            <tr><td>Allowances</td><td>{{ $item->currency }} {{ number_format($item->housing_allowance + $item->transport_allowance + $item->other_allowances, 3) }}</td></tr>
            <tr><td><strong>Gross</strong></td><td><strong>{{ $item->currency }} {{ number_format($item->gross_salary, 3) }}</strong></td></tr>
        </table>
        
        <table>
            <tr><td>GOSI</td><td>-{{ $item->currency }} {{ number_format($item->gosi_employee, 3) }}</td></tr>
            <tr><td><strong>Total Deductions</strong></td><td><strong>-{{ $item->currency }} {{ number_format($item->total_deductions, 3) }}</strong></td></tr>
        </table>
        
        <div class="net-pay">
            <h2>NET PAY: {{ $item->currency }} {{ number_format($item->net_salary, 3) }}</h2>
        </div>
    </div>
</body>
</html>
