#!/bin/bash
# ============================================
# HOSTINGER VPS SYNC - Setup in Bahrain CRM
# Server: 62.72.0.130
# User: setupinbh07
# ============================================

HOSTINGER_HOST="62.72.0.130"
HOSTINGER_USER="setupinbh07"
HOSTINGER_PATH="/home/setupinbh07/public_html"
HOSTINGER_PORT="22"

GREEN='\033[0;32m'
YELLOW='\033[1;33m'
RED='\033[0;31m'
NC='\033[0m'

echo -e "${GREEN}🚀 Syncing Business Platform to Hostinger VPS...${NC}"
echo -e "Server: ${YELLOW}$HOSTINGER_HOST${NC}"
echo -e "Path: ${YELLOW}$HOSTINGER_PATH${NC}"
echo ""

# Sync files using rsync
rsync -avz --progress \
    --exclude='.git' \
    --exclude='node_modules' \
    --exclude='vendor' \
    --exclude='.env' \
    --exclude='storage/logs/*' \
    --exclude='storage/framework/cache/*' \
    --exclude='storage/framework/sessions/*' \
    --exclude='storage/framework/views/*' \
    -e "ssh -p $HOSTINGER_PORT" \
    ./ $HOSTINGER_USER@$HOSTINGER_HOST:$HOSTINGER_PATH/

echo ""
echo -e "${GREEN}✅ Files synced successfully!${NC}"
echo ""
echo -e "${YELLOW}Running post-deployment commands...${NC}"

# Run commands on server
ssh -p $HOSTINGER_PORT $HOSTINGER_USER@$HOSTINGER_HOST << 'ENDSSH'
cd ~/public_html
echo "📦 Installing Composer dependencies..."
composer install --no-dev --optimize-autoloader --no-interaction
echo "🗃️ Running migrations..."
php artisan migrate --force
echo "⚡ Caching configuration..."
php artisan config:cache
php artisan route:cache
php artisan view:cache
php artisan storage:link
echo "✅ Deployment complete!"
ENDSSH

echo ""
echo -e "${GREEN}🎉 Deployment to Hostinger VPS complete!${NC}"
echo -e "Access at: ${YELLOW}http://62.72.0.130${NC}"
